//Scripted by Midnight Dragon
using System;
using Server;

namespace Server.Items
{
	[FlipableAttribute( 0xF43, 0xF44 )] 
	public class MelisandesCorrodedHatchet : BaseAxe
	{
		public override int LabelNumber{ get{ return 1072115; } } // Melisande's Corroded Hatchet
		
      public override WeaponAbility PrimaryAbility{ get{ return WeaponAbility.ArmorIgnore; } }
		public override WeaponAbility SecondaryAbility{ get{ return WeaponAbility.Disarm; } }

		public override int AosStrengthReq{ get{ return 20; } }
		public override int AosMinDamage{ get{ return 13; } }
		public override int AosMaxDamage{ get{ return 15; } }
		public override int AosSpeed{ get{ return 41; } }

		public override int OldStrengthReq{ get{ return 15; } }
		public override int OldMinDamage{ get{ return 2; } }
		public override int OldMaxDamage{ get{ return 17; } }
		public override int OldSpeed{ get{ return 40; } }

		public override int InitMinHits{ get{ return 75; } }
		public override int InitMaxHits{ get{ return 75; } }

		[Constructable]
		public MelisandesCorrodedHatchet() : base( 0xF43 )
		{
			Weight = 4.0;
         Hue = 1172;

			SkillBonuses.SetValues( 0, SkillName.Lumberjacking, 5.0 );
			Attributes.SpellChanneling = 1;
			Attributes.WeaponSpeed = 15;
			Attributes.WeaponDamage = -50;
			WeaponAttributes.SelfRepair = 4;
		}

		public MelisandesCorrodedHatchet( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}
		
		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}